<?php
/*
«Copyright 2007 Max Barel a_x@ac-mb.info»
Release : 0.4 ($Rev: 67 $)
$Date: 2008-03-09 22:02:56 +0100 (Sun, 09 Mar 2008) $

This file is part of HoP.

HoP is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

HoP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with HoP; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

class Hop_page extends Hop_node {
	public $id; //page id is needed to avoid conflict in the gobal pool when several pages are built, i.e. for html messages
	
	function __construct($title_or_options = array()) {
		//options_array_or_object = array('title' => string, 'lang' => string, 'id' => string)
		
		//default options
		$title = 'Webmaster forgot to set this title!';
		$lang = 'en';
		$id = 'main';
		if (is_string($title_or_options)) $title = $title_or_options;
		else extract((array) $title_or_options);
		 
		$hop = Hop::single(); //get the global hop factory
		$this->doctype = $this->add('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">' . (Hop_element::$pack ? "\n" : ''))->last();
		$this->html = $hop->html("{$id}_html")->xmlns('http://www.w3.org/1999/xhtml')->set_attr('xml:lang', $lang)->lang($lang);
		$this->add($this->html);
		$this->head = $hop->head("{$id}_head");
		$this->html->add($this->head);
		$this->head->add($hop->meta("{$id}_content_type")->set_attr('http-equiv', 'Content-Type')->set_attr('content', 'text/html; charset=utf-8'));
		$this->title = $hop->title($title);
		$this->head->add($this->title);
		$this->body = $hop->body("{$id}_body");
		$this->html->add($this->body);
	}

	public static function factory($title = 'Webmaster forgot to set this title!') {
		return new self($title);
	}
	
}

?>
