<?php
/*
«Copyright 2007 Max Barel a_x@ac-mb.info»
Release : 0.4 ($Rev: 86 $)
$Date: 2014-12-14 21:18:10 +0100 (Dim, 14 déc 2014) $

This file is part of HoP.

HoP is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

HoP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with HoP; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

class Hop_menu extends Hop_element
{
	function __construct($options = array()) {
		// array('id' => 'menu_id', 'items' => array('item_id' => 'item_content'), 'page' => node, 'css' => filepath)
		$hop = Hop::single(); //get the global hop factory
		//default settings
		$id = 'menu';
		$page = null;
		$items = array();
		$css = 'hop/widgets/hop_menu.css';
		$class = 'hop_menu';
		extract ((array) $options); // get settings from options
		parent::__construct('ul', array('id'=>$id, 'nl'=>2));
		$this->set_class($class);
		foreach ($items as $it_id => $item) $this->add_item($item, $it_id);
		if ($css and $page and isset($page->head) and !isset($page->head->hop_menu))
			$page->head
				->insert($hop->link('hop_menu')->set_rel('stylesheet')->type('text/css')->set_media('screen')->set_href($css))
				->insert("\n\t\t" . '<!--[if lt IE 7]><style type="text/css">body {behavior: url("js/csshover.htc");}</style><![endif]-->') //[if lt IE 7]
			;
	}
	
	public static function factory($options = array()) {
		return new self($options);
	}
	
	public function sub_menu(self $m, $index = null) {
		if (isset($this->$index)) $this->$index->add($m)->add_class('has_sub_menu');
		elseif (isset($this->content[$index])) $this->content[$index]->add($m)->add_class('has_sub_menu');
		else $this->last()->add($m)->add_class('has_sub_menu');
		return $this;
	}
		
	public function add_item($item = null, $options = null) {
		$hop = Hop::single(); //get the global hop factory
		$this->add($hop->li($item, $options));
		return $this;
	}
}

?>
