<?php
/*
«Copyright 2007 Max Barel a_x@ac-mb.info»
Release : 0.4 ($Rev: 84 $)
$Date: 2009-05-14 21:24:32 +0200 (Jeu, 14 mai 2009) $

This file is part of HoP.

HoP is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

HoP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with HoP; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
	This simple class define a base container, which has no proper output rendered, only contained nodes (or elements).
	It is the base of the Hop_element class.
	It must be used per see, each time one need an abstract container to hold contents.
*/
class Hop_node {
	public $container; //for nesting management
	public $content = array(); // the content of the object, rendered by the render() method
	
	public function __clone() {
		$this->container = null;
		foreach ($this->content as $i => $el) if ( $el instanceof Hop_node ) {
			$this->content[$i] = clone $el;
			$this->content[$i]->set_container($this);
		}
	}
	
	protected function set_container($node) {
		//this function can be redefined in descendant class to supplement the linking task (e.g. from container to child)
		$this->container = $node;
	}
	
	function cut() {
		if ($this->container) {
			foreach($this->container->content as $i => $o) if ($o === $this) unset($this->container->content[$i]);
			$this->container = null;
		}
		return $this;
	}

	//setter
	//these three functions add element to content
	function set_content($el = null) {
		if ( is_array($el) ) $this->content = $el;
		elseif ($el !== null) $this->content = array($el);
		foreach ($this->content as $el)
			if ( $el instanceof Hop_node ) $el->set_container($this);
		return $this;
	}
	function add($el = null) {
		if ($el !== null) $this->content[] = $el; //allow any type, only string and Hop_node are rendered, everything else is casted to string
		if ( $el instanceof Hop_node ) $el->set_container($this);
		return $this;
	}
	function insert($el = null) {
		if ($el !== null) array_unshift($this->content, $el);
		if ( $el instanceof Hop_node ) $el->set_container($this);
		return $this;
	}
	function insert_at($pos, $el = null) {
		if ($el !== null) array_splice ( $this->content , $pos , 0 , array($el) );
		if ( $el instanceof Hop_node ) $el->set_container($this);
		return $this;
	}
	public function insert_before($el = null) {
		$i = $this->index();
		$this->container->insert_at($i, $el);
		return $this;
	}
	public function insert_after($el = null) {
		$i = $this->index() + 1;
		if (!$i) $i = count($this->container);
		$this->container->insert_at($i, $el);
		return $this;
	}

	//getter
	//commodity method. return the last element of content array
	function last() { return end($this->content); }
	//commodity method. return the first element of content array
	function first() { return reset($this->content); }
	function container() { return $this->container; }
	//index of this element
	public function index() {
		if ($this->container) foreach ($this->container->content as $i=>$el) if ($el === $this) return $i;
		return 0;
	}
	
	//render this element, recursively
	function render($indent = '') {
		$html_string = '';
		if ($this->content and !is_array($this->content)) $this->content = (array) $this->content; //in case the content has been overwritten with a string
		foreach ($this->content as $el) {
			if ( $el instanceof Hop_node ) $html_string .= $el->render($indent);
			elseif (is_string($el)) $html_string .= (string) $el;
			else $html_string .= print_r($el, true); //debug purpose don't rely on it
		}
		return $html_string;
	}
	
}
?>
