<?php
/*
«Copyright 2007 Max Barel a_x@ac-mb.info»
Release : 0.4 ($Rev: 86 $)
$Date: 2014-12-14 21:18:10 +0100 (Dim, 14 déc 2014) $

This file is part of HoP.

HoP is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or
(at your option) any later version.

HoP is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with HoP; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/*
	==================================
	library include and autoload
	==================================
*/
set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__FILE__) . PATH_SEPARATOR . dirname(__FILE__) . '/widgets');

function __autoload($class_name) { require_once strtolower($class_name) . '.php'; }
// function __autoload_hop($class_name) { require_once strtolower($class_name) . '.php'; }
// spl_autoload_register('__autoload_hop');

/*
	This class is a commodity one, which encapsulate any useful method not pertaining to nodes classes.
	It is designed have only one instance, created after the class declaration as the global variable $hop.
	This is the only identifier of the HOP library in the global namespace.
	The most useful feature is a trap made with the __call magic method. This offers an automatic html objects creation for every type :
	$hop->div() to instantiate a div, and so on.
	Default setting allow creation of any arbitrary element, even invalid like $hop->menu() etc.
	To restrict the element creation to valid types, set the $hop->single_line property to the relevant list o types.
	
	==================================
	container elements
	==================================
	Element of this kind are rendered with a newline before both opening and closing tag :
	<div>
		<div>
		</div>
	</div>
	As content is more likely to be added with add() or insert methods, it is the second (optional) parameter.
	$d = $hop->div('div1','initial content')->add('added content');
	The first parameter can be either a string and then interpreted as the object id or an array or object of properties of the new object.
	==================================
	One line elements (default)
	==================================
	Rendered on one line :
	<p>text</p>
	The content parameter it the first : $p = $hop->p('text', $options).
	Content adding methods are still usable: $p->add('another text')->add(span('special text')->set_class('special'));
	==================================
	Inflow elements
	==================================
	Rendered in flow, without any newline :
	text before<span>special text</span>text after
	The content parameter it the first : $sp = $hop->span('special text', $options).
	Content adding methods are still usable: $sp->add('another text')->set_class('special'));		
	==================================
	Empty elements
	==================================
	There is no content so the only, optional parameter is id/options :
	$inp = $hop->input('txt1')->set_type('text')->set_value('default value'); //flow way
	$inp = $hop->input(array('id'=>'txt1', 'attributes' => array('type' => 'text', 'value' => 'default text'))); // options way
*/
class Hop {
	private static $single_hop;
	private function __construct() {}
	
	static function single() {
		$c = __CLASS__;
		if (!self::$single_hop) self::$single_hop = new $c;
		return self::$single_hop;
	}
	
	// Following properties can be set to different tag list to adapt rendering to your preference.
	// The first three are exclusives to each other
	public $container = array('html', 'head', 'body', 'div', 'ul', 'ol', 'dl', 'pre', 'blockquote', 'object', 'table', 'caption', 'tbody', 'tr', 'form', 'fieldset', 'select');
	public $single_line = null;
	public $in_flow = array('span', 'a', 'em', 'strong', 'dfn', 'code', 'samp', 'kbd', 'var', 'cite', 'abbr', 'acronym', 'sub', 'sup', 'ins', 'del');
	// This property define empty elements and should not be changed unless set to another markup.
	public $empty_el = array('br', 'hr', 'base', 'meta', 'link', 'param', 'area', 'img', 'input', 'col');
	
	//auto named elements
	public $auto_name = array('input', 'select', 'textarea');
	//auto id elements (useful for label to form elements)
	public $auto_id = array(); //'input select textarea';
	
	public function __call($element_type, $params) {
		$params[] = null; $params[] = null; //add null values to ensure the minimum params number
		//default settings
		$nl = 1;
		$options = $params[1];
		$content = $params[0];
		$check_valid = false;
		if (in_array($element_type, $this->container)) {
			$options = $params[0]; // id/options is first parameter for container
			$content = $params[1];			
			$nl = 2;
			$check_valid = true;
		} elseif (in_array($element_type, $this->empty_el)) {
			if (is_string($params[0])) {
				$options = new stdClass();
				$options->id = $params[0];
			}
			else $options = (object) $params[0]; // id/options is the sole parameter for empty elements
			$options->empty_el = true;
			$content = null;
			$check_valid = true;
		}
		if (in_array($element_type, $this->in_flow)) {
			$nl = 0;
			$check_valid = true;
		}
		if ($check_valid or !$this->single_line or in_array($element_type, $this->single_line)) {
			$el = new Hop_element($element_type, $options);
			$el->set_content($content)->nl($nl);
			if (in_array($element_type, $this->auto_name)) $el->auto_name(true);
			if (in_array($element_type, $this->auto_id)) $el->auto_id(true);
			return $el;
		} else throw new Exception("undefined tag: $element_type");
	}
	
	/*
		This function return a hop_element object given its id. Or the global pool if none.
		$o = $hop->pool('anID');
		$o = $hop->pool()->anId;
		$o = Hop_element::$pool->$id;
	*/
	function pool($id = null) {
		if ($id) return @Hop_element::$pool->$id; // isset(Hop_element::$pool->$id) ? Hop_element::$pool->$id :null;
		return Hop_element::$pool;
	}
	
	function clone_el($el) {
		if (is_string($el)) $el = $this->pool($el);
		return clone $el;
	}
}

$hop = Hop::single();

?>
